/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz.actions;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.SearchGuardModulesRegistry;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.whoami.WhoAmIAction;
import com.floragunn.searchguard.authc.internal_users_db.InternalUsersConfigApi;
import com.floragunn.searchguard.authc.session.GetActivatedFrontendConfigAction;
import com.floragunn.searchguard.authc.session.backend.SessionApi;
import com.floragunn.searchguard.authz.actions.Action;
import com.floragunn.searchguard.configuration.api.BulkConfigApi;
import com.floragunn.searchguard.configuration.variables.ConfigVarApi;
import com.floragunn.searchguard.configuration.variables.ConfigVarRefreshAction;
import com.floragunn.searchguard.modules.api.GetComponentStateAction;
import com.floragunn.searchsupport.reflection.ReflectiveAttributeAccessors;
import com.floragunn.searchsupport.xcontent.AttributeValueFromXContent;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.cluster.allocation.ClusterAllocationExplainAction;
import org.elasticsearch.action.admin.cluster.configuration.AddVotingConfigExclusionsAction;
import org.elasticsearch.action.admin.cluster.configuration.ClearVotingConfigExclusionsAction;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthAction;
import org.elasticsearch.action.admin.cluster.node.hotthreads.NodesHotThreadsAction;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoAction;
import org.elasticsearch.action.admin.cluster.node.reload.NodesReloadSecureSettingsAction;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsAction;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksAction;
import org.elasticsearch.action.admin.cluster.node.tasks.get.GetTaskAction;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksAction;
import org.elasticsearch.action.admin.cluster.node.usage.NodesUsageAction;
import org.elasticsearch.action.admin.cluster.remote.RemoteInfoAction;
import org.elasticsearch.action.admin.cluster.repositories.cleanup.CleanupRepositoryAction;
import org.elasticsearch.action.admin.cluster.repositories.delete.DeleteRepositoryAction;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesAction;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryAction;
import org.elasticsearch.action.admin.cluster.repositories.verify.VerifyRepositoryAction;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteAction;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsAction;
import org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsAction;
import org.elasticsearch.action.admin.cluster.snapshots.clone.CloneSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsAction;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusAction;
import org.elasticsearch.action.admin.cluster.state.ClusterStateAction;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsAction;
import org.elasticsearch.action.admin.cluster.storedscripts.DeleteStoredScriptAction;
import org.elasticsearch.action.admin.cluster.storedscripts.GetScriptContextAction;
import org.elasticsearch.action.admin.cluster.storedscripts.GetScriptLanguageAction;
import org.elasticsearch.action.admin.cluster.storedscripts.GetStoredScriptAction;
import org.elasticsearch.action.admin.cluster.storedscripts.PutStoredScriptAction;
import org.elasticsearch.action.admin.cluster.tasks.PendingClusterTasksAction;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesAction;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.exists.AliasesExistAction;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesAction;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeAction;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheAction;
import org.elasticsearch.action.admin.indices.close.CloseIndexAction;
import org.elasticsearch.action.admin.indices.create.AutoCreateAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.dangling.delete.DeleteDanglingIndexAction;
import org.elasticsearch.action.admin.indices.dangling.find.FindDanglingIndexAction;
import org.elasticsearch.action.admin.indices.dangling.import_index.ImportDanglingIndexAction;
import org.elasticsearch.action.admin.indices.dangling.list.ListDanglingIndicesAction;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexAction;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsAction;
import org.elasticsearch.action.admin.indices.flush.FlushAction;
import org.elasticsearch.action.admin.indices.flush.SyncedFlushAction;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeAction;
import org.elasticsearch.action.admin.indices.get.GetIndexAction;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsAction;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsAction;
import org.elasticsearch.action.admin.indices.mapping.put.AutoPutMappingAction;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingAction;
import org.elasticsearch.action.admin.indices.open.OpenIndexAction;
import org.elasticsearch.action.admin.indices.readonly.AddIndexBlockAction;
import org.elasticsearch.action.admin.indices.recovery.RecoveryAction;
import org.elasticsearch.action.admin.indices.refresh.RefreshAction;
import org.elasticsearch.action.admin.indices.resolve.ResolveIndexAction;
import org.elasticsearch.action.admin.indices.rollover.RolloverAction;
import org.elasticsearch.action.admin.indices.segments.IndicesSegmentsAction;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsAction;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsAction;
import org.elasticsearch.action.admin.indices.shards.IndicesShardStoresAction;
import org.elasticsearch.action.admin.indices.shrink.ResizeAction;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsAction;
import org.elasticsearch.action.admin.indices.template.delete.DeleteComponentTemplateAction;
import org.elasticsearch.action.admin.indices.template.delete.DeleteComposableIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.get.GetComponentTemplateAction;
import org.elasticsearch.action.admin.indices.template.get.GetComposableIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesAction;
import org.elasticsearch.action.admin.indices.template.post.SimulateIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.post.SimulateTemplateAction;
import org.elasticsearch.action.admin.indices.template.put.PutComponentTemplateAction;
import org.elasticsearch.action.admin.indices.template.put.PutComposableIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateAction;
import org.elasticsearch.action.admin.indices.upgrade.get.UpgradeStatusAction;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeAction;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeSettingsAction;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryAction;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.delete.DeleteAction;
import org.elasticsearch.action.explain.ExplainAction;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesAction;
import org.elasticsearch.action.get.GetAction;
import org.elasticsearch.action.get.MultiGetAction;
import org.elasticsearch.action.index.IndexAction;
import org.elasticsearch.action.ingest.DeletePipelineAction;
import org.elasticsearch.action.ingest.GetPipelineAction;
import org.elasticsearch.action.ingest.PutPipelineAction;
import org.elasticsearch.action.ingest.SimulatePipelineAction;
import org.elasticsearch.action.main.MainAction;
import org.elasticsearch.action.search.ClearScrollAction;
import org.elasticsearch.action.search.MultiSearchAction;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchScrollAction;
import org.elasticsearch.action.termvectors.MultiTermVectorsAction;
import org.elasticsearch.action.termvectors.TermVectorsAction;
import org.elasticsearch.action.update.UpdateAction;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.ReindexAction;
import org.elasticsearch.index.reindex.UpdateByQueryAction;
import org.elasticsearch.index.seqno.RetentionLeaseActions;
import org.elasticsearch.persistent.CompletionPersistentTaskAction;
import org.elasticsearch.persistent.RemovePersistentTaskAction;
import org.elasticsearch.persistent.StartPersistentTaskAction;
import org.elasticsearch.persistent.UpdatePersistentTaskStatusAction;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.xcontent.ToXContent;

public class Actions {
    private final ImmutableMap<String, Action> actionMap;
    private final ImmutableSet<Action.WellKnownAction<?, ?, ?>> indexActions;
    private final ImmutableSet<Action.WellKnownAction<?, ?, ?>> clusterActions;
    private final ImmutableSet<Action.WellKnownAction<?, ?, ?>> tenantActions;
    private Builder builder = new Builder();

    public Actions(SearchGuardModulesRegistry modulesRegistry) {
        this.index((ActionType<?>)IndexAction.INSTANCE);
        this.index((ActionType<?>)GetAction.INSTANCE);
        this.index((ActionType<?>)TermVectorsAction.INSTANCE);
        this.index((ActionType<?>)DeleteAction.INSTANCE);
        this.index((ActionType<?>)UpdateAction.INSTANCE);
        this.index((ActionType<?>)SearchAction.INSTANCE);
        this.index((ActionType<?>)ExplainAction.INSTANCE);
        this.index((ActionType<?>)ResolveIndexAction.INSTANCE);
        this.index((ActionType<?>)UpdateByQueryAction.INSTANCE);
        this.index((ActionType<?>)DeleteByQueryAction.INSTANCE);
        this.index("indices:data/write/bulk[s]").requestType(BulkShardRequest.class).requestItemsA(BulkShardRequest::items, item -> item.request().opType()).requiresAdditionalPrivilegesForItemType(DocWriteRequest.OpType.DELETE, "indices:data/write/delete", new String[0]).requiresAdditionalPrivilegesForItemType(DocWriteRequest.OpType.INDEX, "indices:data/write/index", new String[0]).requiresAdditionalPrivilegesForItemType(DocWriteRequest.OpType.CREATE, "indices:data/write/index", new String[0]).requiresAdditionalPrivilegesForItemType(DocWriteRequest.OpType.UPDATE, "indices:data/write/index", new String[0]);
        this.index((ActionType<?>)ClusterSearchShardsAction.INSTANCE).requiresAdditionalPrivileges(Actions.always(), "indices:data/read/search", new String[0]);
        this.cluster((ActionType<?>)MultiGetAction.INSTANCE);
        this.cluster((ActionType<?>)BulkAction.INSTANCE);
        this.cluster((ActionType<?>)SearchScrollAction.INSTANCE);
        this.cluster((ActionType<?>)MultiSearchAction.INSTANCE);
        this.cluster((ActionType<?>)MultiTermVectorsAction.INSTANCE);
        this.cluster("indices:data/read/search/template");
        this.cluster("indices:data/read/msearch/template");
        this.index((ActionType<?>)IndicesStatsAction.INSTANCE);
        this.index((ActionType<?>)IndicesSegmentsAction.INSTANCE);
        this.index((ActionType<?>)IndicesShardStoresAction.INSTANCE);
        this.index((ActionType<?>)CreateIndexAction.INSTANCE).requestType(CreateIndexRequest.class).requiresAdditionalPrivileges(Actions.ifNotEmpty(CreateIndexRequest::aliases), "indices:admin/aliases", new String[0]);
        this.index((ActionType<?>)ResizeAction.INSTANCE);
        this.index((ActionType<?>)RolloverAction.INSTANCE);
        this.index((ActionType<?>)DeleteIndexAction.INSTANCE);
        this.index((ActionType<?>)GetIndexAction.INSTANCE);
        this.index((ActionType<?>)OpenIndexAction.INSTANCE);
        this.index((ActionType<?>)CloseIndexAction.INSTANCE);
        this.index((ActionType<?>)IndicesExistsAction.INSTANCE);
        this.index((ActionType<?>)AddIndexBlockAction.INSTANCE);
        this.index((ActionType<?>)GetMappingsAction.INSTANCE);
        this.index((ActionType<?>)GetFieldMappingsAction.INSTANCE);
        this.index((ActionType<?>)PutMappingAction.INSTANCE);
        this.index((ActionType<?>)AutoPutMappingAction.INSTANCE);
        this.index((ActionType<?>)IndicesAliasesAction.INSTANCE).requestType(IndicesAliasesRequest.class).requestItems(IndicesAliasesRequest::getAliasActions, IndicesAliasesRequest.AliasActions::actionType).requiresAdditionalPrivilegesForItemType(IndicesAliasesRequest.AliasActions.Type.REMOVE_INDEX, "indices:admin/delete", new String[0]);
        this.index((ActionType<?>)UpdateSettingsAction.INSTANCE);
        this.index((ActionType<?>)AnalyzeAction.INSTANCE);
        this.index((ActionType<?>)AutoCreateAction.INSTANCE);
        this.cluster((ActionType<?>)ClearScrollAction.INSTANCE);
        this.cluster((ActionType<?>)RecoveryAction.INSTANCE);
        this.cluster((ActionType<?>)NodesReloadSecureSettingsAction.INSTANCE);
        this.cluster("indices:data/read/async_search/submit").createsResource("async_search", ReflectiveAttributeAccessors.objectAttr((String)"id"), Actions.xContentInstantFromMillis("expiration_time_in_millis"));
        this.cluster("indices:data/read/async_search/get").uses(new Action.WellKnownAction.Resource("async_search", ReflectiveAttributeAccessors.objectAttr((String)"id")).ownerCheckBypassPermission("indices:searchguard:async_search/_all_owners"));
        this.cluster("indices:data/read/async_search/delete").deletes(new Action.WellKnownAction.Resource("async_search", ReflectiveAttributeAccessors.objectAttr((String)"id")).ownerCheckBypassPermission("indices:searchguard:async_search/_all_owners"));
        this.cluster("indices:searchguard:async_search/_all_owners");
        this.cluster("indices:data/read/sql");
        this.cluster("indices:data/read/sql/translate");
        this.cluster("indices:data/read/sql/close_cursor");
        this.cluster((ActionType<?>)MainAction.INSTANCE);
        this.cluster((ActionType<?>)NodesInfoAction.INSTANCE);
        this.cluster((ActionType<?>)RemoteInfoAction.INSTANCE);
        this.cluster((ActionType<?>)NodesStatsAction.INSTANCE);
        this.cluster((ActionType<?>)NodesUsageAction.INSTANCE);
        this.cluster((ActionType<?>)NodesHotThreadsAction.INSTANCE);
        this.cluster((ActionType<?>)ListTasksAction.INSTANCE);
        this.cluster((ActionType<?>)GetTaskAction.INSTANCE);
        this.cluster((ActionType<?>)CancelTasksAction.INSTANCE);
        this.cluster((ActionType<?>)AddVotingConfigExclusionsAction.INSTANCE);
        this.cluster((ActionType<?>)ClearVotingConfigExclusionsAction.INSTANCE);
        this.cluster((ActionType<?>)ClusterAllocationExplainAction.INSTANCE);
        this.cluster((ActionType<?>)ClusterStatsAction.INSTANCE);
        this.cluster((ActionType<?>)ClusterStateAction.INSTANCE);
        this.cluster((ActionType<?>)ClusterHealthAction.INSTANCE);
        this.cluster((ActionType<?>)ClusterUpdateSettingsAction.INSTANCE);
        this.cluster((ActionType<?>)ClusterRerouteAction.INSTANCE);
        this.cluster((ActionType<?>)PendingClusterTasksAction.INSTANCE);
        this.cluster((ActionType<?>)PutRepositoryAction.INSTANCE);
        this.cluster((ActionType<?>)GetRepositoriesAction.INSTANCE);
        this.cluster((ActionType<?>)DeleteRepositoryAction.INSTANCE);
        this.cluster((ActionType<?>)VerifyRepositoryAction.INSTANCE);
        this.cluster((ActionType<?>)CleanupRepositoryAction.INSTANCE);
        this.cluster((ActionType<?>)GetSnapshotsAction.INSTANCE);
        this.cluster((ActionType<?>)DeleteSnapshotAction.INSTANCE);
        this.cluster((ActionType<?>)CreateSnapshotAction.INSTANCE);
        this.cluster((ActionType<?>)CloneSnapshotAction.INSTANCE);
        this.cluster((ActionType<?>)RestoreSnapshotAction.INSTANCE).requestType(RestoreSnapshotRequest.class).requiresAdditionalPrivileges(Actions.always(), "indices:admin/create", "indices:data/write/index");
        this.cluster((ActionType<?>)SnapshotsStatusAction.INSTANCE);
        this.cluster((ActionType<?>)ReindexAction.INSTANCE);
        this.cluster((ActionType<?>)PutIndexTemplateAction.INSTANCE);
        this.cluster((ActionType<?>)GetIndexTemplatesAction.INSTANCE);
        this.cluster((ActionType<?>)DeleteIndexTemplateAction.INSTANCE);
        this.cluster((ActionType<?>)PutComponentTemplateAction.INSTANCE);
        this.cluster((ActionType<?>)GetComponentTemplateAction.INSTANCE);
        this.cluster((ActionType<?>)DeleteComponentTemplateAction.INSTANCE);
        this.cluster((ActionType<?>)PutComposableIndexTemplateAction.INSTANCE);
        this.cluster((ActionType<?>)GetComposableIndexTemplateAction.INSTANCE);
        this.cluster((ActionType<?>)DeleteComposableIndexTemplateAction.INSTANCE);
        this.cluster((ActionType<?>)SimulateIndexTemplateAction.INSTANCE);
        this.cluster((ActionType<?>)SimulateTemplateAction.INSTANCE);
        this.index((ActionType<?>)ValidateQueryAction.INSTANCE);
        this.index((ActionType<?>)RefreshAction.INSTANCE);
        this.index("indices:admin/refresh[s]");
        this.index((ActionType<?>)FlushAction.INSTANCE);
        this.index((ActionType<?>)SyncedFlushAction.INSTANCE);
        this.index((ActionType<?>)ForceMergeAction.INSTANCE);
        this.index((ActionType<?>)UpgradeAction.INSTANCE);
        this.index((ActionType<?>)UpgradeStatusAction.INSTANCE);
        this.index((ActionType<?>)UpgradeSettingsAction.INSTANCE);
        this.index((ActionType<?>)ClearIndicesCacheAction.INSTANCE);
        this.index((ActionType<?>)GetAliasesAction.INSTANCE);
        this.index((ActionType<?>)AliasesExistAction.INSTANCE);
        this.index((ActionType<?>)GetSettingsAction.INSTANCE);
        this.index((ActionType<?>)FieldCapabilitiesAction.INSTANCE);
        this.cluster((ActionType<?>)PutStoredScriptAction.INSTANCE);
        this.cluster((ActionType<?>)GetStoredScriptAction.INSTANCE);
        this.cluster((ActionType<?>)DeleteStoredScriptAction.INSTANCE);
        this.cluster((ActionType<?>)GetScriptContextAction.INSTANCE);
        this.cluster((ActionType<?>)GetScriptLanguageAction.INSTANCE);
        this.cluster((ActionType<?>)PutPipelineAction.INSTANCE);
        this.cluster((ActionType<?>)GetPipelineAction.INSTANCE);
        this.cluster((ActionType<?>)DeletePipelineAction.INSTANCE);
        this.cluster((ActionType<?>)SimulatePipelineAction.INSTANCE);
        this.cluster((ActionType<?>)StartPersistentTaskAction.INSTANCE);
        this.cluster((ActionType<?>)UpdatePersistentTaskStatusAction.INSTANCE);
        this.cluster((ActionType<?>)CompletionPersistentTaskAction.INSTANCE);
        this.cluster((ActionType<?>)RemovePersistentTaskAction.INSTANCE);
        this.cluster((ActionType<?>)ListDanglingIndicesAction.INSTANCE);
        this.cluster((ActionType<?>)ImportDanglingIndexAction.INSTANCE);
        this.cluster((ActionType<?>)DeleteDanglingIndexAction.INSTANCE);
        this.cluster((ActionType<?>)FindDanglingIndexAction.INSTANCE);
        this.cluster("cluster:admin/snapshot/status[nodes]");
        this.open((ActionType<?>)RetentionLeaseActions.Add.INSTANCE);
        this.open((ActionType<?>)RetentionLeaseActions.Renew.INSTANCE);
        this.open((ActionType<?>)RetentionLeaseActions.Remove.INSTANCE);
        this.cluster(ConfigUpdateAction.INSTANCE);
        this.cluster(GetComponentStateAction.INSTANCE);
        this.cluster((ActionType<?>)BulkConfigApi.GetAction.INSTANCE);
        this.cluster((ActionType<?>)BulkConfigApi.UpdateAction.INSTANCE);
        this.cluster(ConfigVarRefreshAction.INSTANCE);
        this.cluster((ActionType<?>)ConfigVarApi.GetAction.INSTANCE);
        this.cluster((ActionType<?>)ConfigVarApi.UpdateAction.INSTANCE);
        this.cluster((ActionType<?>)ConfigVarApi.DeleteAction.INSTANCE);
        this.cluster((ActionType<?>)ConfigVarApi.GetAllAction.INSTANCE);
        this.cluster((ActionType<?>)ConfigVarApi.UpdateAllAction.INSTANCE);
        this.cluster((ActionType<?>)InternalUsersConfigApi.GetAction.INSTANCE);
        this.cluster((ActionType<?>)InternalUsersConfigApi.DeleteAction.INSTANCE);
        this.cluster((ActionType<?>)InternalUsersConfigApi.PutAction.INSTANCE);
        this.cluster((ActionType<?>)InternalUsersConfigApi.PatchAction.INSTANCE);
        this.cluster((ActionType<?>)GetActivatedFrontendConfigAction.INSTANCE);
        this.cluster((ActionType<?>)SessionApi.CreateAction.INSTANCE);
        this.cluster((ActionType<?>)SessionApi.DeleteAction.INSTANCE);
        this.cluster((ActionType<?>)SessionApi.GetExtendedInfoAction.INSTANCE);
        this.cluster("cluster:admin:searchguard:login/session");
        this.tenant("kibana:saved_objects/_/read");
        this.tenant("kibana:saved_objects/_/write");
        this.open("cluster:admin/searchguard/license/info");
        this.open(WhoAmIAction.INSTANCE);
        if (modulesRegistry != null) {
            for (ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse> action : modulesRegistry.getActions()) {
                this.builder.action(action.getAction());
            }
        }
        this.actionMap = this.builder.build();
        ImmutableSet.Builder clusterActions = new ImmutableSet.Builder(this.actionMap.size());
        ImmutableSet.Builder indexActions = new ImmutableSet.Builder(this.actionMap.size());
        ImmutableSet.Builder tenantActions = new ImmutableSet.Builder();
        for (Action action : this.actionMap.values()) {
            if (action.isClusterPrivilege()) {
                clusterActions.add((Object)((Action.WellKnownAction)action));
                continue;
            }
            if (action.isTenantPrivilege()) {
                tenantActions.add((Object)((Action.WellKnownAction)action));
                continue;
            }
            indexActions.add((Object)((Action.WellKnownAction)action));
        }
        this.clusterActions = clusterActions.build();
        this.indexActions = indexActions.build();
        this.tenantActions = tenantActions.build();
    }

    public Action get(String actionName) {
        Action result = (Action)this.actionMap.get((Object)actionName);
        if (result != null) {
            return result;
        }
        return new Action.OtherAction(actionName, Actions.getScope(actionName));
    }

    public ImmutableSet<Action.WellKnownAction<?, ?, ?>> clusterActions() {
        return this.clusterActions;
    }

    public ImmutableSet<Action.WellKnownAction<?, ?, ?>> indexActions() {
        return this.indexActions;
    }

    public ImmutableSet<Action.WellKnownAction<?, ?, ?>> tenantActions() {
        return this.tenantActions;
    }

    private static Scope getScope(String action) {
        if (action.startsWith("cluster:admin:searchguard:tenant:") || action.startsWith("kibana:saved_objects/")) {
            return Scope.TENANT;
        }
        if (action.startsWith("searchguard:cluster:") || action.startsWith("cluster:")) {
            return Scope.CLUSTER;
        }
        return Scope.INDEX;
    }

    private <RequestType extends ActionRequest> ActionBuilder<RequestType, Void, Void> cluster(ActionType<?> actionType) {
        return this.builder.cluster(actionType);
    }

    private ActionBuilder<?, ?, ?> cluster(String action) {
        return this.builder.cluster(action);
    }

    private ActionBuilder<?, ?, ?> index(ActionType<?> actionType) {
        return this.builder.index(actionType);
    }

    private ActionBuilder<?, ?, ?> index(String action) {
        return this.builder.index(action);
    }

    private ActionBuilder<?, ?, ?> tenant(String action) {
        return this.builder.tenant(action);
    }

    private <RequestType extends ActionRequest> ActionBuilder<RequestType, Void, Void> open(ActionType<?> actionType) {
        return this.builder.open(actionType);
    }

    private ActionBuilder<?, ?, ?> open(String action) {
        return this.builder.open(action);
    }

    static <O> Function<O, Object> xContentAttr(String name) {
        return actionResponse -> AttributeValueFromXContent.get((ToXContent)((ToXContent)actionResponse), (String)name);
    }

    static <O> Function<O, Instant> xContentInstantFromMillis(String name) {
        return actionResponse -> {
            Object value = AttributeValueFromXContent.get((ToXContent)((ToXContent)actionResponse), (String)name);
            if (value instanceof Number) {
                return Instant.ofEpochMilli(((Number)value).longValue());
            }
            if (value == null) {
                return null;
            }
            throw new RuntimeException("Unexpected value " + value + " for attribute " + name);
        };
    }

    static <T> Predicate<T> ifNotEmpty(Function<T, Collection<?>> itemFunction) {
        return t -> {
            Collection items = (Collection)itemFunction.apply(t);
            return items != null && !items.isEmpty();
        };
    }

    static <Request extends ActionRequest> Predicate<Request> always() {
        return request -> true;
    }

    class ActionBuilder<RequestType extends ActionRequest, RequestItem, RequestItemType> {
        private Class<RequestType> requestType;
        private String requestTypeName;
        private String actionName;
        private Class<Enum<?>> requestItemTypeEnum;
        private Action.WellKnownAction.NewResource createsResource;
        private List<Action.WellKnownAction.Resource> usesResources = new ArrayList<Action.WellKnownAction.Resource>();
        private List<Action.WellKnownAction.RequestPropertyModifier<?>> requestProperyModifiers = new ArrayList();
        private List<Action.WellKnownAction.AdditionalPrivileges<RequestType, RequestItem>> additionalPrivileges = new ArrayList<Action.WellKnownAction.AdditionalPrivileges<RequestType, RequestItem>>();
        private Map<RequestItemType, ImmutableSet<String>> additionalPrivilegesByItemType;
        private Scope scope;
        private Function<RequestType, Collection<RequestItem>> requestItemFunction;
        private Function<RequestItem, RequestItemType> requestItemTypeFunction;

        ActionBuilder(String actionName, Scope scope) {
            this.actionName = actionName;
            this.scope = scope;
        }

        <NewRequestType extends ActionRequest> ActionBuilder<NewRequestType, RequestItem, RequestItemType> requestType(Class<NewRequestType> requestType) {
            if (this.requestType != null && !this.requestType.equals(requestType)) {
                throw new IllegalStateException("Request type was already set: " + requestType + " vs " + this.requestType);
            }
            ActionBuilder newRequestTypeBuilder = this;
            newRequestTypeBuilder.requestType = requestType;
            return newRequestTypeBuilder;
        }

        ActionBuilder<RequestType, RequestItem, RequestItemType> requestType(String requestType) {
            try {
                this.requestType = Class.forName(requestType);
            }
            catch (ClassNotFoundException e) {
                this.requestTypeName = requestType;
            }
            return this;
        }

        <NewRequestItem> ActionBuilder<RequestType, NewRequestItem, RequestItemType> requestItems(Function<RequestType, Collection<NewRequestItem>> function) {
            ActionBuilder newRequestTypeBuilder = this;
            newRequestTypeBuilder.requestItemFunction = function;
            return newRequestTypeBuilder;
        }

        <NewRequestItem, NewRequestItemType> ActionBuilder<RequestType, NewRequestItem, NewRequestItemType> requestItems(Function<RequestType, Collection<NewRequestItem>> function, Function<NewRequestItem, NewRequestItemType> requestItemTypeFunction) {
            ActionBuilder newRequestTypeBuilder = this;
            newRequestTypeBuilder.requestItemFunction = function;
            newRequestTypeBuilder.requestItemTypeFunction = requestItemTypeFunction;
            return newRequestTypeBuilder;
        }

        <NewRequestItem, NewRequestItemType> ActionBuilder<RequestType, NewRequestItem, NewRequestItemType> requestItemsA(Function<RequestType, NewRequestItem[]> function, Function<NewRequestItem, NewRequestItemType> requestItemTypeFunction) {
            ActionBuilder newRequestTypeBuilder = this;
            newRequestTypeBuilder.requestItemFunction = r -> Arrays.asList((Object[])function.apply(r));
            newRequestTypeBuilder.requestItemTypeFunction = requestItemTypeFunction;
            return newRequestTypeBuilder;
        }

        ActionBuilder<RequestType, RequestItem, RequestItemType> requiresAdditionalPrivileges(Predicate<RequestType> condition, String privilege, String ... morePrivileges) {
            this.additionalPrivileges.add(new Action.WellKnownAction.AdditionalPrivileges((ImmutableSet<String>)ImmutableSet.of((Object)privilege, (Object[])morePrivileges), condition));
            return this;
        }

        ActionBuilder<RequestType, RequestItem, RequestItemType> requiresAdditionalPrivilegesForItemType(RequestItemType requestItemType, String privilege, String ... morePrivileges) {
            ImmutableSet<String> existingPrivileges;
            ImmutableSet privileges = ImmutableSet.of((Object)privilege, (Object[])morePrivileges);
            if (this.additionalPrivilegesByItemType == null) {
                if (Enum.class.isAssignableFrom(requestItemType.getClass())) {
                    Class<?> requestItemTypeClass = requestItemType.getClass();
                    EnumMap additionalPrivilegesByItemType = new EnumMap(requestItemTypeClass);
                    this.additionalPrivilegesByItemType = additionalPrivilegesByItemType;
                    Class<?> enumClass = requestItemType.getClass();
                    this.requestItemTypeEnum = enumClass;
                } else {
                    this.additionalPrivilegesByItemType = new HashMap<RequestItemType, ImmutableSet<String>>();
                }
            }
            if ((existingPrivileges = this.additionalPrivilegesByItemType.get(requestItemType)) == null) {
                this.additionalPrivilegesByItemType.put(requestItemType, (ImmutableSet<String>)privileges);
            } else {
                this.additionalPrivilegesByItemType.put(requestItemType, (ImmutableSet<String>)privileges.with(existingPrivileges));
            }
            return this;
        }

        ActionBuilder<RequestType, RequestItem, RequestItemType> createsResource(String type, Function<ActionResponse, Object> id, Function<ActionResponse, Instant> expiresAfter) {
            this.createsResource = new Action.WellKnownAction.NewResource(type, id, expiresAfter);
            return this;
        }

        ActionBuilder<RequestType, RequestItem, RequestItemType> uses(Action.WellKnownAction.Resource resource) {
            this.usesResources.add(resource);
            return this;
        }

        ActionBuilder<RequestType, RequestItem, RequestItemType> deletes(Action.WellKnownAction.Resource resource) {
            this.usesResources.add(resource.deleteAction(true));
            return this;
        }

        <PropertyType> ActionBuilder<RequestType, RequestItem, RequestItemType> setRequestProperty(String name, Class<PropertyType> type, Function<PropertyType, PropertyType> function) {
            this.requestProperyModifiers.add(new Action.WellKnownAction.RequestPropertyModifier<PropertyType>(ReflectiveAttributeAccessors.objectAttr((String)name, type), ReflectiveAttributeAccessors.setObjectAttr((String)name, type), type, function));
            return this;
        }

        Action build() {
            Action.WellKnownAction.Resources resources = null;
            if (this.createsResource != null || !this.usesResources.isEmpty()) {
                resources = new Action.WellKnownAction.Resources(this.createsResource, this.usesResources);
            }
            Action.WellKnownAction.RequestItems<RequestType, RequestItem, RequestItemType> requestItems = null;
            if (this.requestItemTypeFunction != null || this.requestItemTypeEnum != null || this.requestItemTypeFunction != null) {
                requestItems = new Action.WellKnownAction.RequestItems<RequestType, RequestItem, RequestItemType>(this.requestItemTypeFunction, this.requestItemFunction, this.additionalPrivilegesByItemType, this.requestItemTypeEnum, Actions.this);
            }
            return new Action.WellKnownAction<RequestType, RequestItem, RequestItemType>(this.actionName, this.scope, this.requestType, this.requestTypeName, ImmutableList.of(this.additionalPrivileges), this.additionalPrivilegesByItemType != null ? ImmutableMap.of(this.additionalPrivilegesByItemType) : ImmutableMap.empty(), requestItems, resources, Actions.this);
        }
    }

    public static enum Scope {
        INDEX,
        CLUSTER,
        TENANT,
        OPEN;

    }

    class Builder {
        private Map<String, ActionBuilder<?, ?, ?>> builders = new HashMap(300);

        Builder() {
        }

        <RequestType extends ActionRequest> ActionBuilder<RequestType, Void, Void> cluster(ActionType<?> actionType) {
            ActionBuilder builder = new ActionBuilder(actionType.name(), Scope.CLUSTER);
            this.builders.put(actionType.name(), builder);
            return builder;
        }

        ActionBuilder<?, ?, ?> cluster(String action) {
            ActionBuilder builder = new ActionBuilder(action, Scope.CLUSTER);
            this.builders.put(action, builder);
            return builder;
        }

        ActionBuilder<?, ?, ?> index(ActionType<?> actionType) {
            ActionBuilder builder = new ActionBuilder(actionType.name(), Scope.INDEX);
            this.builders.put(actionType.name(), builder);
            return builder;
        }

        ActionBuilder<?, ?, ?> index(String action) {
            ActionBuilder builder = new ActionBuilder(action, Scope.INDEX);
            this.builders.put(action, builder);
            return builder;
        }

        ActionBuilder<?, ?, ?> tenant(String action) {
            ActionBuilder builder = new ActionBuilder(action, Scope.TENANT);
            this.builders.put(action, builder);
            return builder;
        }

        <RequestType extends ActionRequest> ActionBuilder<RequestType, Void, Void> open(ActionType<?> actionType) {
            ActionBuilder builder = new ActionBuilder(actionType.name(), Scope.OPEN);
            this.builders.put(actionType.name(), builder);
            return builder;
        }

        ActionBuilder<?, ?, ?> open(String action) {
            ActionBuilder builder = new ActionBuilder(action, Scope.OPEN);
            this.builders.put(action, builder);
            return builder;
        }

        ActionBuilder<?, ?, ?> action(ActionType<?> actionType) {
            ActionBuilder builder = new ActionBuilder(actionType.name(), Actions.getScope(actionType.name()));
            this.builders.put(actionType.name(), builder);
            return builder;
        }

        ImmutableMap<String, Action> build() {
            ImmutableMap.Builder result = new ImmutableMap.Builder(this.builders.size());
            for (ActionBuilder<?, ?, ?> builder : this.builders.values()) {
                Action action = builder.build();
                result.with((Object)((ActionBuilder)builder).actionName, (Object)action);
            }
            this.builders = null;
            return result.build();
        }
    }
}

